<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) $data = $_POST;

    if (empty($data["AdminSupport"]) && empty($data["AddMoney"]) &&
        empty($data["JoinMatch"]) && empty($data["Withdraw"])) {

        echo json_encode(["status" => "error", "message" => "At least one field is required"]);
        exit;
    }

    $AdminSupport = trim($data["AdminSupport"]);
    $AddMoney     = trim($data["AddMoney"]);
    $JoinMatch    = trim($data["JoinMatch"]);
    $Withdraw     = trim($data["Withdraw"]);

    $sql = "INSERT INTO `link` (`id`, `AdminSupport`, `AddMoney`, `JoinMatch`, `Withdraw`) 
            VALUES (1, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE 
                `AdminSupport` = VALUES(`AdminSupport`),
                `AddMoney`     = VALUES(`AddMoney`),
                `JoinMatch`    = VALUES(`JoinMatch`),
                `Withdraw`     = VALUES(`Withdraw`),
                `created_at`   = CURRENT_TIMESTAMP";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $AdminSupport, $AddMoney, $JoinMatch, $Withdraw);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Link data saved successfully (always ID=1)",
            "id" => 1,
            "AdminSupport" => $AdminSupport,
            "AddMoney" => $AddMoney,
            "JoinMatch" => $JoinMatch,
            "Withdraw" => $Withdraw
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Save failed",
            "error" => $stmt->error
        ]);
    }

    $stmt->close();
} 
else if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    $result = $conn->query("SELECT * FROM `link` WHERE `id` = 1 LIMIT 1");

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode([
            "status" => "success",
            "id" => $row["id"],
            "AdminSupport" => $row["AdminSupport"],
            "AddMoney" => $row["AddMoney"],
            "JoinMatch" => $row["JoinMatch"],
            "Withdraw" => $row["Withdraw"],
            "created_at" => $row["created_at"]
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No link data found"
        ]);
    }
}

$conn->close();
?>